/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx.ft4222;

import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.ft4222.FT_4222_Gpio;
import com.ftdi.j2xx.ft4222.FT_4222_I2c_Master;
import com.ftdi.j2xx.ft4222.FT_4222_I2c_Slave;
import com.ftdi.j2xx.ft4222.FT_4222_Spi_Master;
import com.ftdi.j2xx.ft4222.FT_4222_Spi_Slave;
import com.ftdi.j2xx.ft4222.SPI_MasterCfg;
import com.ftdi.j2xx.ft4222.chiptop_mgr;
import com.ftdi.j2xx.ft4222.gpio_mgr;
import com.ftdi.j2xx.interfaces.Gpio;
import com.ftdi.j2xx.interfaces.I2cMaster;
import com.ftdi.j2xx.interfaces.I2cSlave;
import com.ftdi.j2xx.interfaces.SpiMaster;
import com.ftdi.j2xx.interfaces.SpiSlave;

public class FT_4222_Device {
    protected String TAG = "FT4222";
    protected FT_Device mFtDev;
    protected chiptop_mgr mChipStatus;
    protected SPI_MasterCfg mSpiMasterCfg;
    protected gpio_mgr mGpio;
    protected char version;

    public FT_4222_Device(FT_Device ftDev) {
        this.mFtDev = ftDev;
        this.mChipStatus = new chiptop_mgr();
        this.mSpiMasterCfg = new SPI_MasterCfg();
        this.mGpio = new gpio_mgr();
    }

    public int init() {
        byte[] buf = new byte[13];
        int ftStatus = this.mFtDev.VendorCmdGet(32, 1, buf, 13);
        if (ftStatus != 13) {
            return 18;
        }
        this.mChipStatus.formByteArray(buf);
        byte[] bVer = new byte[12];
        ftStatus = this.mFtDev.VendorCmdGet(32, 0, bVer, 12);
        if (ftStatus < 0) {
            return 18;
        }
        if (bVer[2] == 1) {
            this.version = (char)65;
        } else if (bVer[2] == 2) {
            this.version = (char)66;
        } else if (bVer[2] == 3) {
            this.version = (char)67;
        } else if (bVer[2] >= 4) {
            this.version = (char)68;
        }
        return 0;
    }

    public int setClock(byte clk) {
        if (clk == this.mChipStatus.clk_ctl) {
            return 0;
        }
        int ftStatus = this.mFtDev.VendorCmdSet(33, 4 | clk << 8);
        if (0 == ftStatus) {
            this.mChipStatus.clk_ctl = clk;
        }
        return ftStatus;
    }

    public int getClock(byte[] clk) {
        if (this.mFtDev.VendorCmdGet(32, 4, clk, 1) >= 0) {
            this.mChipStatus.clk_ctl = clk[0];
            return 0;
        }
        return 18;
    }

    public boolean cleanRxData() {
        byte[] rd_tmp_buf;
        int ret = this.mFtDev.getQueueStatus();
        return ret <= 0 || (ret = this.mFtDev.read(rd_tmp_buf = new byte[ret], ret)) == rd_tmp_buf.length;
    }

    protected int getMaxBuckSize() {
        if (0 != this.mChipStatus.fs_only) {
            return 64;
        }
        switch (this.mChipStatus.chip_mode) {
            default: {
                return 512;
            }
            case 1: 
            case 2: 
        }
        return 256;
    }

    public boolean isFT4222Device() {
        if (this.mFtDev != null) {
            switch (this.mFtDev.getDeviceInfo().bcdDevice & 0xFF00) {
                case 6144: {
                    this.mFtDev.getDeviceInfo().type = 10;
                    return true;
                }
                case 6400: {
                    this.mFtDev.getDeviceInfo().type = 11;
                    return true;
                }
                case 5888: {
                    this.mFtDev.getDeviceInfo().type = 12;
                    return true;
                }
            }
        }
        return false;
    }

    public I2cMaster getI2cMasterDevice() {
        if (!this.isFT4222Device()) {
            return null;
        }
        return new FT_4222_I2c_Master(this);
    }

    public I2cSlave getI2cSlaveDevice() {
        if (!this.isFT4222Device()) {
            return null;
        }
        return new FT_4222_I2c_Slave(this);
    }

    public SpiMaster getSpiMasterDevice() {
        if (!this.isFT4222Device()) {
            return null;
        }
        return new FT_4222_Spi_Master(this);
    }

    public SpiSlave getSpiSlaveDevice() {
        if (!this.isFT4222Device()) {
            return null;
        }
        return new FT_4222_Spi_Slave(this);
    }

    public Gpio getGpioDevice() {
        if (!this.isFT4222Device()) {
            return null;
        }
        return new FT_4222_Gpio(this);
    }

    public int setSuspendOut(boolean bValue) {
        int ftStatus = bValue ? this.mFtDev.VendorCmdSet(33, 263) : this.mFtDev.VendorCmdSet(33, 7);
        if (0 == ftStatus) {
            this.mChipStatus.enable_suspend_out = bValue ? (byte)1 : 0;
        }
        return ftStatus;
    }

    public int setInterruptEnable(boolean bValue) {
        int ftStatus = bValue ? this.mFtDev.VendorCmdSet(33, 262) : this.mFtDev.VendorCmdSet(33, 6);
        if (0 == ftStatus) {
            this.mChipStatus.enable_wakeup_int = bValue ? (byte)1 : 0;
        }
        return ftStatus;
    }

    public int setInterruptTrigger(int triggerType) {
        int intrLevel = 0;
        if (triggerType != 1 && triggerType != 2 && triggerType != 4 && triggerType != 8) {
            return 6;
        }
        switch (triggerType) {
            case 1: {
                intrLevel = 0;
                break;
            }
            case 2: {
                intrLevel = 2;
                break;
            }
            case 4: {
                intrLevel = 1;
                break;
            }
            case 8: {
                intrLevel = 3;
            }
        }
        int ftStatus = this.mFtDev.VendorCmdSet(33, 0x10 | intrLevel << 8);
        if (0 == ftStatus) {
            this.mGpio.intrLevel = triggerType;
        }
        return ftStatus;
    }

    public int chipReset() {
        int ftStatus = this.mFtDev.VendorCmdSet(33, 128);
        return ftStatus;
    }

    public char GetVersion() {
        return this.version;
    }
}

