/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx.ft4222;

import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.ft4222.FT_4222_Device;
import com.ftdi.j2xx.interfaces.I2cMaster;

public class FT_4222_I2c_Master
implements I2cMaster {
    FT_4222_Device mFt4222Dev;
    FT_Device mFtDev;
    int mI2cMasterKbps;

    public FT_4222_I2c_Master(FT_4222_Device ft4222Device) {
        this.mFt4222Dev = ft4222Device;
        this.mFtDev = this.mFt4222Dev.mFtDev;
    }

    int cmdSet(int wValue1, int wValue2) {
        return this.mFtDev.VendorCmdSet(33, wValue1 | wValue2 << 8);
    }

    int cmdSet(int wValue1, int wValue2, byte[] buf, int datalen) {
        return this.mFtDev.VendorCmdSet(33, wValue1 | wValue2 << 8, buf, datalen);
    }

    int cmdGet(int wValue1, int wValue2, byte[] buf, int datalen) {
        return this.mFtDev.VendorCmdGet(32, wValue1 | wValue2 << 8, buf, datalen);
    }

    @Override
    public int init(int kbps) {
        byte[] clk = new byte[1];
        int ftStatus = this.mFt4222Dev.init();
        if (0 != ftStatus) {
            return ftStatus;
        }
        if (!this.I2C_Mode_Check()) {
            return 1012;
        }
        this.cmdSet(81, 0);
        ftStatus = this.mFt4222Dev.getClock(clk);
        if (0 != ftStatus) {
            return ftStatus;
        }
        int i2cMP = this.i2c_master_setup_timer_period(clk[0], kbps);
        ftStatus = this.cmdSet(5, 1);
        if (ftStatus < 0) {
            return ftStatus;
        }
        this.mFt4222Dev.mChipStatus.function = 1;
        ftStatus = this.cmdSet(82, i2cMP);
        if (ftStatus < 0) {
            return ftStatus;
        }
        this.mI2cMasterKbps = kbps;
        return 0;
    }

    @Override
    public int reset() {
        int reset = 1;
        int ftStatus = this.I2C_Check(true);
        if (0 != ftStatus) {
            return ftStatus;
        }
        return this.cmdSet(81, reset);
    }

    @Override
    public int read(int deviceAddress, byte[] buffer, int sizeToTransfer, int[] sizeTransferred) {
        return this.readEx(deviceAddress, 6, buffer, sizeToTransfer, sizeTransferred);
    }

    @Override
    public int readEx(int deviceAddress, int flag, byte[] buffer, int sizeToTransfer, int[] sizeTransferred) {
        short slave_addr = (short)(deviceAddress & 0xFFFF);
        short shortSizeToTransfer = (short)sizeToTransfer;
        byte[] headBuf = new byte[4];
        int notReadBytes = sizeToTransfer;
        int readBytes = 0;
        if (buffer.length < sizeToTransfer) {
            return 1023;
        }
        int ftStatus = this.I2C_Version_Check(flag);
        if (0 != ftStatus) {
            return ftStatus;
        }
        ftStatus = this.I2C_Address_Check(deviceAddress);
        if (0 != ftStatus) {
            return ftStatus;
        }
        if (sizeToTransfer < 1) {
            return 6;
        }
        ftStatus = this.I2C_Check(true);
        if (0 != ftStatus) {
            return ftStatus;
        }
        slave_addr = (short)((slave_addr << 1) + 1);
        headBuf[0] = (byte)slave_addr;
        headBuf[1] = (byte)flag;
        headBuf[2] = (byte)(shortSizeToTransfer >> 8 & 0xFF);
        headBuf[3] = (byte)(shortSizeToTransfer & 0xFF);
        ftStatus = this.mFtDev.write(headBuf, 4);
        if (4 != ftStatus) {
            return 1011;
        }
        int dataSize = 0;
        int TRANSFER_BUFFER_SIZE = 1024;
        byte[] transferBuf = new byte[TRANSFER_BUFFER_SIZE];
        int buf_access_index = 0;
        sizeTransferred[0] = 0;
        while (notReadBytes > 0) {
            dataSize = this.mFtDev.getQueueStatus();
            if (dataSize == 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (dataSize > notReadBytes) {
                dataSize = notReadBytes;
            }
            if (dataSize > TRANSFER_BUFFER_SIZE) {
                dataSize = TRANSFER_BUFFER_SIZE;
            }
            if ((readBytes = this.mFtDev.read(transferBuf, dataSize)) < 0) {
                return 1011;
            }
            for (int i = 0; i < readBytes; ++i) {
                buffer[buf_access_index] = transferBuf[i];
                ++buf_access_index;
            }
            sizeTransferred[0] = sizeTransferred[0] + readBytes;
            notReadBytes -= readBytes;
            if (readBytes >= dataSize) continue;
            return 1011;
        }
        return 0;
    }

    @Override
    public int write(int deviceAddress, byte[] buffer, int sizeToTransfer, int[] sizeTransferred) {
        return this.writeEx(deviceAddress, 6, buffer, sizeToTransfer, sizeTransferred);
    }

    @Override
    public int writeEx(int deviceAddress, int flag, byte[] buffer, int sizeToTransfer, int[] sizeTransferred) {
        short slave_addr = (short)deviceAddress;
        short shortSizeToTransfer = (short)sizeToTransfer;
        byte[] transferBuf = new byte[sizeToTransfer + 4];
        int[] maxSize = new int[1];
        if (buffer.length < sizeToTransfer) {
            return 1023;
        }
        int ftStatus = this.I2C_Version_Check(flag);
        if (0 != ftStatus) {
            return ftStatus;
        }
        ftStatus = this.I2C_Address_Check(deviceAddress);
        if (ftStatus != 0) {
            return ftStatus;
        }
        if (sizeToTransfer < 1) {
            return 6;
        }
        ftStatus = this.I2C_Check(true);
        if (ftStatus != 0) {
            return ftStatus;
        }
        if (6 == flag) {
            return this.writeAuto(deviceAddress, flag, buffer, sizeToTransfer, sizeTransferred);
        }
        ftStatus = this.getMaxTransferSize(maxSize);
        if (0 != ftStatus) {
            return ftStatus;
        }
        if (sizeToTransfer > maxSize[0]) {
            return 1010;
        }
        sizeTransferred[0] = 0;
        slave_addr = (short)(slave_addr << 1);
        transferBuf[0] = (byte)slave_addr;
        transferBuf[1] = (byte)flag;
        transferBuf[2] = (byte)(shortSizeToTransfer >> 8 & 0xFF);
        transferBuf[3] = (byte)(shortSizeToTransfer & 0xFF);
        for (int i = 0; i < sizeToTransfer; ++i) {
            transferBuf[i + 4] = buffer[i];
        }
        ftStatus = this.mFtDev.write(transferBuf, sizeToTransfer + 4);
        if (ftStatus < 0) {
            return 10;
        }
        sizeTransferred[0] = ftStatus - 4;
        return 0;
    }

    int writeAuto(int deviceAddress, int flag, byte[] buffer, int sizeToTransfer, int[] sizeTransferred) {
        short slave_addr = (short)deviceAddress;
        int[] maxSize = new int[1];
        int sentBytes = 0;
        int ftStatus = this.getMaxTransferSize(maxSize);
        if (0 != ftStatus) {
            return ftStatus;
        }
        boolean bFirst = true;
        int sendFlag = 0;
        byte[] transferBuf = new byte[maxSize[0] + 4];
        int buf_access_index = 0;
        slave_addr = (short)(slave_addr << 1);
        transferBuf[0] = (byte)slave_addr;
        sizeTransferred[0] = 0;
        for (int notSentBytes = sizeToTransfer; notSentBytes > 0; notSentBytes -= sentBytes - 4) {
            sendFlag = 0;
            int data_size = Math.min(maxSize[0], notSentBytes);
            if (bFirst) {
                if ((flag & 2) == 2) {
                    sendFlag = (byte)(flag & 3);
                }
                bFirst = false;
            }
            if (notSentBytes == data_size && (flag & 4) == 4) {
                sendFlag = (byte)(sendFlag | 4);
            }
            if (sendFlag == 0) {
                sendFlag = -128;
            }
            transferBuf[1] = sendFlag;
            transferBuf[2] = (byte)(data_size >> 8 & 0xFF);
            transferBuf[3] = (byte)(data_size & 0xFF);
            for (int i = 0; i < data_size; ++i) {
                transferBuf[i + 4] = buffer[buf_access_index];
                ++buf_access_index;
            }
            sentBytes = this.mFtDev.write(transferBuf, data_size + 4);
            if (sentBytes < 0) {
                return 10;
            }
            sizeTransferred[0] = sizeTransferred[0] + (sentBytes - 4);
        }
        return 0;
    }

    @Override
    public int getStatus(int deviceAddress, byte[] controllerStatus) {
        int ftStatus = this.I2C_Check(true);
        if (0 != ftStatus) {
            return ftStatus;
        }
        ftStatus = this.mFtDev.VendorCmdGet(34, 62900, controllerStatus, 1);
        if (ftStatus < 0) {
            return 18;
        }
        return 0;
    }

    boolean I2C_Mode_Check() {
        return this.mFt4222Dev.mChipStatus.chip_mode == 0 || this.mFt4222Dev.mChipStatus.chip_mode == 3;
    }

    int I2C_Check(boolean isMaster) {
        if (isMaster ? this.mFt4222Dev.mChipStatus.function != 1 : this.mFt4222Dev.mChipStatus.function != 2) {
            return 1004;
        }
        return 0;
    }

    int I2C_Version_Check(int flag) {
        char fwVer;
        if (this.mFtDev == null || !this.mFtDev.isOpen()) {
            return 3;
        }
        if (flag != 6 && (fwVer = this.getFWVersion()) < 'B') {
            return 1022;
        }
        return 0;
    }

    int I2C_Address_Check(int deviceAddress) {
        if ((deviceAddress & 0xFC00) > 0) {
            return 1007;
        }
        return 0;
    }

    private int i2c_master_setup_timer_period(int CLK_CTRL, int kbps) {
        int I2CMTP;
        double CLK_PRD;
        switch (CLK_CTRL) {
            default: {
                CLK_PRD = 16.666666666666668;
                break;
            }
            case 1: {
                CLK_PRD = 41.666666666666664;
                break;
            }
            case 2: {
                CLK_PRD = 20.833333333333332;
                break;
            }
            case 3: {
                CLK_PRD = 12.5;
            }
        }
        if (kbps <= 100) {
            int SCL_LP = 2;
            int SCL_HP = 2;
            double SCL_PERIOD = 1000000.0 / (double)kbps;
            int TIMER_PRD = (int)(SCL_PERIOD / (8.0 * CLK_PRD) - 1.0 + 0.5);
            if (TIMER_PRD > 127) {
                TIMER_PRD = 127;
            }
            I2CMTP = TIMER_PRD;
        } else if (100 < kbps && kbps <= 400) {
            int TIMER_PRD;
            int SCL_LP = 2;
            boolean SCL_HP = true;
            double SCL_PERIOD = 1000000.0 / (double)kbps;
            I2CMTP = TIMER_PRD = (int)(SCL_PERIOD / (6.0 * CLK_PRD) - 1.0 + 0.5);
            I2CMTP |= 0xC0;
        } else if (400 < kbps && kbps <= 1000) {
            int TIMER_PRD;
            int SCL_LP = 2;
            boolean SCL_HP = true;
            double SCL_PERIOD = 1000000.0 / (double)kbps;
            I2CMTP = TIMER_PRD = (int)(SCL_PERIOD / (6.0 * CLK_PRD) - 1.0 + 0.5);
            I2CMTP |= 0xC0;
        } else if (1000 < kbps && kbps <= 3400) {
            int TIMER_PRD;
            int SCL_LP = 2;
            boolean SCL_HP = true;
            double SCL_PERIOD = 1000000.0 / (double)kbps;
            I2CMTP = TIMER_PRD = (int)(SCL_PERIOD / (6.0 * CLK_PRD) - 1.0 + 0.5);
            I2CMTP |= 0x80;
            I2CMTP &= 0xFFFFFFBF;
        } else {
            I2CMTP = 74;
        }
        return I2CMTP;
    }

    public int getMaxTransferSize(int[] pMaxSize) {
        pMaxSize[0] = 0;
        int maxBuckSize = this.mFt4222Dev.getMaxBuckSize();
        switch (this.mFt4222Dev.mChipStatus.function) {
            case 1: {
                pMaxSize[0] = maxBuckSize - 4;
                break;
            }
            default: {
                return 17;
            }
        }
        return 0;
    }

    char getFWVersion() {
        return this.mFt4222Dev.GetVersion();
    }
}

